package ru.yandex.direct.binlogbroker.logbrokerwriter.models;

import java.util.Collection;
import java.util.List;

import ru.yandex.direct.binlogbroker.logbrokerwriter.components.DataFormat;

import static java.util.stream.Collectors.toList;
import static ru.yandex.direct.binlogbroker.logbrokerwriter.components.DataFormat.JSON;
import static ru.yandex.direct.binlogbroker.logbrokerwriter.components.DataFormat.PROTOBUF;

public enum WorkMode {
    // при добавлении новых work mode может понадобиться нестандартно перезапускать приложение, см. https://st.yandex-team.ru/DIRECT-160414
    PROTOBUF_0(PROTOBUF, 0),
    PROTOBUF_1(PROTOBUF, 1),
    PROTOBUF_2(PROTOBUF, 2),
    PROTOBUF_3(PROTOBUF, 3),
    JSON_0(JSON, 0, true),
    JSON_1(JSON, 1),
    JSON_2(JSON, 2),
    JSON_3(JSON, 3);

    public static final int CHUNKS_COUNT = 4;

    private DataFormat dataFormat;
    private int chunk;
    private boolean writePpcDict;

    WorkMode(DataFormat dataFormat, int chunk) {
        this(dataFormat, chunk, false);
    }

    WorkMode(DataFormat dataFormat, int chunk, boolean writePpcDict) {
        this.dataFormat = dataFormat;
        this.chunk = chunk;
        this.writePpcDict = writePpcDict;
    }

    @Override
    public String toString() {
        return dataFormat + "-" + chunk;
    }

    public DataFormat getDataFormat() {
        return dataFormat;
    }

    public boolean getWritePpcDict() {
        return writePpcDict;
    }

    public List<Integer> getShards(Collection<Integer> totalShards) {
            return totalShards.stream()
                .filter(shard -> shard % CHUNKS_COUNT == chunk)
                .distinct()
                .collect(toList());
    }

    public int getChunkId() {
        return chunk;
    }
}
