package ru.yandex.direct.binlogbroker.ytbootstrap;

import javax.annotation.ParametersAreNonnullByDefault;

import org.slf4j.Logger;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

import ru.yandex.direct.binlogbroker.ytbootstrap.components.MultipleDatabaseYtBootstrap;
import ru.yandex.direct.binlogbroker.ytbootstrap.configuration.YtBootstrapConfiguration;
import ru.yandex.direct.binlogbroker.ytbootstrap.jcommander.CommonParameters;
import ru.yandex.direct.binlogbroker.ytbootstrap.jcommander.MySqlParameters;
import ru.yandex.direct.binlogbroker.ytbootstrap.jcommander.YtParameters;
import ru.yandex.direct.jcommander.ParserWithHelp;
import ru.yandex.direct.logging.LoggingInitializer;
import ru.yandex.direct.logging.LoggingInitializerParams;

@ParametersAreNonnullByDefault
public class YtBootstrap {
    private static final Logger logger = LoggingInitializer.getLogger(YtBootstrap.class);

    private YtBootstrap() {
    }

    public static void main(String[] args) throws InterruptedException {
        final CommonParameters commonParameters = new CommonParameters();
        final MySqlParameters mySqlParameters = new MySqlParameters();
        final YtParameters ytParameters = new YtParameters();
        final LoggingInitializerParams loggingInitializerParams = new LoggingInitializerParams();

        ParserWithHelp.parse(
                YtBootstrap.class.getCanonicalName(),
                args,
                loggingInitializerParams,
                commonParameters, mySqlParameters, ytParameters);

        LoggingInitializer.initialize(loggingInitializerParams);

        AnnotationConfigApplicationContext context =
                new AnnotationConfigApplicationContext(YtBootstrapConfiguration.class);
        context.getBeanFactory().registerSingleton("commonParameters", commonParameters);
        context.getBeanFactory().registerSingleton("mySqlParameters", mySqlParameters);
        context.getBeanFactory().registerSingleton("ytParameters", ytParameters);

        final MultipleDatabaseYtBootstrap databaseYtBootstrap =
                (MultipleDatabaseYtBootstrap) context.getBean("databaseYtBootstrap");
        try {
            databaseYtBootstrap.run();
        } catch (Throwable ex) {
            logger.error("YtBootstrap failed", ex);
            throw ex;
        } finally {
            context.destroy();
        }
    }
}
