package ru.yandex.direct.binlogbroker.ytbootstrap.components;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@ParametersAreNonnullByDefault
class DatabaseYtBootstrapState implements Serializable {

    String source;
    int batchRows;
    int batchEvents;

    Map<String, TableState> tables = new HashMap<>();

    DatabaseYtBootstrapState() {
    }

    DatabaseYtBootstrapState(String source, int batchRows, int batchEvents) {
        this.source = source;
        this.batchRows = batchRows;
        this.batchEvents = batchEvents;
    }

    static class TableState implements Serializable {

        Map<String, Object> lastReadPrimaryKey = new HashMap<>();

        /**
         * event batches that are in queue or in the middle of writing to YT
         */
        Set<Map<String, Object>> batchesInProgress = new HashSet<>();
    }
}
