package ru.yandex.direct.binlogbroker.ytbootstrap.components;

import java.time.Duration;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.utils.Completer;

@ParametersAreNonnullByDefault
public class MultipleDatabaseYtBootstrap {
    private final List<DatabaseYtBootstrap> nested;

    public MultipleDatabaseYtBootstrap(List<DatabaseYtBootstrap> nested) {
        this.nested = nested;
    }

    public void run() throws InterruptedException {
        Completer.Builder builder = new Completer.Builder(Duration.ofMinutes(1));
        for (DatabaseYtBootstrap bootstrap : nested) {
            builder.submitVoid(
                    "Bootstrap for " + bootstrap.getSource(),
                    bootstrap::run
            );
        }
        try (Completer completer = builder.build()) {
            completer.waitAll();
        }
    }
}
