package ru.yandex.direct.binlogbroker.ytbootstrap.configuration;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.SQLDialect;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

import ru.yandex.direct.binlogbroker.logbroker_utils.models.SourceTypeHelper;
import ru.yandex.direct.binlogbroker.logbrokerwriter.models.SourceDbConfigs;
import ru.yandex.direct.binlogbroker.replicatetoyt.RetryingYtReplicator;
import ru.yandex.direct.binlogbroker.replicatetoyt.YtReplicator;
import ru.yandex.direct.binlogbroker.replicatetoyt.YtReplicatorImpl;
import ru.yandex.direct.binlogbroker.replicatetoyt.configuration.YtReplicatorConfiguration;
import ru.yandex.direct.binlogbroker.ytbootstrap.components.DatabaseYtBootstrap;
import ru.yandex.direct.binlogbroker.ytbootstrap.components.MultipleDatabaseYtBootstrap;
import ru.yandex.direct.binlogbroker.ytbootstrap.jcommander.CommonParameters;
import ru.yandex.direct.binlogbroker.ytbootstrap.jcommander.MySqlParameters;
import ru.yandex.direct.binlogbroker.ytbootstrap.jcommander.YtParameters;
import ru.yandex.direct.config.EssentialConfiguration;
import ru.yandex.direct.db.config.DbConfig;
import ru.yandex.direct.db.config.DbConfigFactory;
import ru.yandex.direct.dbutil.configuration.DbUtilConfiguration;
import ru.yandex.direct.dbutil.wrapper.DataSourceFactory;
import ru.yandex.direct.dbutil.wrapper.DatabaseWrapper;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.yt.ytclient.proxy.YtClient;

@ParametersAreNonnullByDefault
@Import(value = {EssentialConfiguration.class, DbUtilConfiguration.class, YtReplicatorConfiguration.class})
public class YtBootstrapConfiguration {
    @Bean
    @Lazy
    public SourceDbConfigs sourceDbConfigs(DbConfigFactory dbConfigFactory, MySqlParameters mySqlParameters,
                                           SourceTypeHelper sourceTypeHelper) {
        return new SourceDbConfigs(sourceTypeHelper.getSources(mySqlParameters.commaDelimitedSources), dbConfigFactory);
    }

    @Bean
    @Lazy
    public YtCluster ytCluster(YtParameters ytParameters) {
        return ytParameters.ytCluster;
    }

    @Bean
    @Lazy
    public YtReplicator ytReplicator(YtClient ytClient, YtParameters ytParameters, Yt yt) {
        return new RetryingYtReplicator(
                new YtReplicatorImpl(
                        ytClient, yt, YPath.simple(ytParameters.ytPath), YPath.simple(ytParameters.tmpYtPath), false));
    }

    @Bean
    @Lazy
    public MultipleDatabaseYtBootstrap databaseYtBootstrap(
            SourceDbConfigs sourceDbConfigs, YtReplicator ytReplicator,
            DataSourceFactory dataSourceFactory, EnvironmentType environmentType,
            MySqlParameters mySqlParameters, CommonParameters commonParameters
    ) {
        List<DatabaseYtBootstrap> bootstrapList = sourceDbConfigs.getSources().stream()
                .map(source -> {
                    final DbConfig dbConfig = sourceDbConfigs.getMysqlConnector(source).get();
                    final DatabaseWrapper databaseWrapper =
                            new DatabaseWrapper(dbConfig.getDb(), dataSourceFactory.createDataSource(dbConfig),
                                    SQLDialect.MYSQL, environmentType);
                    return new DatabaseYtBootstrap(ignored -> databaseWrapper, source.getSourceName(),
                            commonParameters.maxMySqlReaderThreads, commonParameters.batchRows,
                            commonParameters.batchEvents,
                            ytReplicator, commonParameters.maxYtReplicatorQueueSize,
                            commonParameters.maxYtReplicatorThreads,
                            mySqlParameters.includeTables, mySqlParameters.excludeTables,
                            commonParameters.maxFetchRows);
                })
                .collect(Collectors.toList());

        return new MultipleDatabaseYtBootstrap(bootstrapList);
    }
}
