package ru.yandex.direct.binlogbroker.ytbootstrap.jcommander;

import javax.annotation.ParametersAreNonnullByDefault;

import com.beust.jcommander.Parameter;

/**
 * все значения, кроме {@link #maxYtReplicatorThreads} взяты с потолка, можно менять по своему разумению
 */
@ParametersAreNonnullByDefault
@SuppressWarnings("checkstyle:visibilitymodifier")
public class CommonParameters {

    @Parameter(
            names = {"--batch-rows"},
            description = "Number of rows to pack into single event"
    )
    public int batchRows = 1000;

    @Parameter(
            names = {"--batch-events"},
            description = "Number of events to submit in single pack to event consumer"
    )
    public int batchEvents = 10;

    @Parameter(
            names = {"--max-mysql-reader-threads"}
    )
    public int maxMySqlReaderThreads = Runtime.getRuntime().availableProcessors();

    @Parameter(
            names = "--max-yt-replicator-threads"
    )
    // предполагается, что потоки YtReplicator будут посылать данные в YT и ждать ответа,
    // поэтому надо много таких потоков.
    public int maxYtReplicatorThreads = Runtime.getRuntime().availableProcessors() * 5;

    @Parameter(
            names = "--max-yt-replicator-queue-size",
            description = "YtReplicator queue size if all threads are busy"
    )
    public int maxYtReplicatorQueueSize = 10;

    @Parameter(
            names = "--max-fetch-rows",
            description = "Roughly limit number of rows, that will be fetched from each MySQL table. "
                    + "WARNING: only for testing/debugging. Default value: no limit"
    )
    public long maxFetchRows = -1L;
}
