package ru.yandex.direct.binlogbroker.ytbootstrap.jcommander;

import java.util.HashSet;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.beust.jcommander.Parameter;

import ru.yandex.direct.binlogbroker.logbrokerwriter.jcommander.EnvironmentTypeConverter;
import ru.yandex.direct.env.EnvironmentType;

@ParametersAreNonnullByDefault
@SuppressWarnings("checkstyle:visibilitymodifier")
public class MySqlParameters {
    @Parameter(
            names = {"--shards"},
            description = "Comma delimited list of sources. By default synchronizes \"ppc:all\"."
    )
    public String commaDelimitedSources;

    @Parameter(
            names = {"--db-config-env"},
            description = "Environment of MySQL servers.",
            converter = EnvironmentTypeConverter.class
    )
    public EnvironmentType dbConfigEnv;

    @Parameter(
            names = {"--mysql-include-tables"},
            variableArity = true
    )
    public Set<String> includeTables = new HashSet<>();

    @Parameter(
            names = {"--mysql-exclude-tables"},
            variableArity = true
    )
    public Set<String> excludeTables = new HashSet<>();
}
