package ru.yandex.direct.binlogbroker.ytbootstrap.jcommander;

import javax.annotation.ParametersAreNonnullByDefault;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.converters.BaseConverter;

import ru.yandex.direct.ytwrapper.model.YtCluster;

@ParametersAreNonnullByDefault
@SuppressWarnings("checkstyle:visibilitymodifier")
public class YtParameters {

    @Parameter(
            names = "--yt-cluster",
            required = true,
            description = "YT cluster for storing tables data",
            converter = YtClusterConverter.class
    )
    public YtCluster ytCluster = YtCluster.HAHN;

    public static class YtClusterConverter extends BaseConverter<YtCluster> {

        public YtClusterConverter(String optionName) {
            super(optionName);
        }

        @Override
        public YtCluster convert(String value) {
            try {
                return YtCluster.valueOf(value.toUpperCase());
            } catch (IllegalArgumentException exc) {
                throw new ParameterException("\"" + getOptionName() + "\": " + exc.getMessage());
            }
        }
    }

    @Parameter(
            names = "--yt-path",
            required = true,
            description = "Base path on YT cluster for storing tables data"
    )
    public String ytPath;

    @Parameter(
            names = "--tmp-yt-path",
            required = true,
            description = "Base path on YT cluster for storing tmp tables"
    )
    public String tmpYtPath;

}
