package ru.yandex.direct.binlogbroker.replicatetoyt;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.AnnotationConfigApplicationContext;

import ru.yandex.direct.binlogbroker.replicatetoyt.components.YtWriterRunnable;
import ru.yandex.direct.binlogbroker.replicatetoyt.configuration.YtWriterConfiguration;
import ru.yandex.direct.binlogbroker.replicatetoyt.configuration.YtWriterJcommanderConfiguration;
import ru.yandex.direct.binlogbroker.replicatetoyt.jcommander.YtWriterParams;
import ru.yandex.direct.jcommander.ParserWithHelp;
import ru.yandex.direct.logging.LoggingInitializer;

@ParametersAreNonnullByDefault
public class YtWriter {
    private YtWriter() {
    }

    public static void main(String[] args) {
        YtWriterParams ytWriterParams = new YtWriterParams();

        ParserWithHelp.parse(YtWriter.class.getCanonicalName(), args, ytWriterParams);

        LoggingInitializer.initialize(ytWriterParams.loggingInitializerParams, YtWriter.class.getCanonicalName());
        YtWriterJcommanderConfiguration.initializeParameters(ytWriterParams);

        try (AnnotationConfigApplicationContext context =
                     new AnnotationConfigApplicationContext(YtWriterConfiguration.class)) {
            ((YtWriterRunnable) context.getBean(YtWriterRunnable.COMPONENT_NAME)).run();
        }
    }
}
