package ru.yandex.direct.binlogbroker.replicatetoyt.components;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import ru.yandex.direct.binlogbroker.logbroker_utils.models.BinlogEventWithOffset;
import ru.yandex.direct.binlogbroker.logbroker_utils.reader.LogbrokerBatchReader;
import ru.yandex.direct.utils.Interrupts;

/**
 * Вся суть репликации на yt. Runnable, который запускается один раз при старте приложения, и при завершении этого
 * runnable приложение завершается.
 */
@Component(YtWriterRunnable.COMPONENT_NAME)
@Lazy
@ParametersAreNonnullByDefault
public class YtWriterRunnable implements Runnable {
    public static final String COMPONENT_NAME = "ytWriterRunnable";
    private final Interrupts.InterruptibleConsumer<List<BinlogEventWithOffset>> eventConsumer;
    private final LogbrokerBatchReader<BinlogEventWithOffset> binlogEventReader;

    @Autowired
    public YtWriterRunnable(Interrupts.InterruptibleConsumer<List<BinlogEventWithOffset>> eventConsumer,
                            LogbrokerBatchReader<BinlogEventWithOffset> binlogEventReader) {
        this.eventConsumer = eventConsumer;
        this.binlogEventReader = binlogEventReader;
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                binlogEventReader.fetchEvents(eventConsumer);
            } catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                // Предполагается, что по окончании этого runnable больше ничего не будет работать.
            }
        }
    }
}
