package ru.yandex.direct.binlogbroker.replicatetoyt.configuration;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.Preconditions;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

import ru.yandex.direct.binlogbroker.replicatetoyt.jcommander.LogbrokerParams;
import ru.yandex.direct.binlogbroker.replicatetoyt.jcommander.YtParams;
import ru.yandex.direct.binlogbroker.replicatetoyt.jcommander.YtWriterParams;
import ru.yandex.direct.config.EssentialConfiguration;

/**
 * spring-конфигурация для прокидывания аргументов командной строки в контекст.
 */
@Configuration
@Import({
        EssentialConfiguration.class,
})
@ParametersAreNonnullByDefault
public class YtWriterJcommanderConfiguration {
    private static YtWriterParams ytWriterParams;

    public static void initializeParameters(YtWriterParams ytWriterParams) {
        YtWriterJcommanderConfiguration.ytWriterParams = ytWriterParams;
    }

    // Lazy(false) - Автоматическая проверка, что метод не забыли позвать. Если захотелось отключить эту проверку, то
    // стоит совсем избавиться от этой конфигурации.
    @Bean
    @Lazy(false)
    public YtWriterParams ytWriterParams() {
        Preconditions.checkState(ytWriterParams != null,
                "You forgot to call %s.initializeParameters()", getClass().getName());
        return ytWriterParams;
    }

    @Bean
    public YtParams ytParams(YtWriterParams ytWriterParams) {
        return ytWriterParams.ytParams;
    }

    @Bean
    public LogbrokerParams logbrokerParams(YtWriterParams ytWriterParams) {
        return ytWriterParams.logbrokerParams;
    }
}
