package ru.yandex.direct.binlogbroker.replicatetoyt.jcommander;

import javax.annotation.ParametersAreNonnullByDefault;

import com.beust.jcommander.Parameter;

@ParametersAreNonnullByDefault
@SuppressWarnings("checkstyle:visibilitymodifier")
public class LogbrokerParams {
    @Parameter(
            names = {"--sources"},
            description = "Comma separated list of sources, e.g. ppc:1,ppc:2."
    )
    public String sources = "";

    @Parameter(
            names = {"--client-id"},
            description = "Logbroker client id",
            required = true
    )
    public String clientId;

    @Parameter(
            names = {"--logbroker-no-commit"},
            description = "Mode for debugging. Do not commit any fetched message from logbroker."
    )
    public boolean logbrokerNoCommit = false;
}
