package ru.yandex.direct.binlogbroker.replicatetoyt.jcommander;

import javax.annotation.ParametersAreNonnullByDefault;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.converters.BaseConverter;

import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.inside.yt.kosher.cypress.YPath;

@ParametersAreNonnullByDefault
@SuppressWarnings("checkstyle:visibilitymodifier")
public class YtParams {
    @Parameter(
            names = "--yt-cluster",
            description = "YT cluster for storing tables data",
            converter = YtClusterConverter.class
    )
    public YtCluster ytCluster = YtCluster.HAHN;

    public static class YtClusterConverter extends BaseConverter<YtCluster> {

        public YtClusterConverter(String optionName) {
            super(optionName);
        }

        @Override
        public YtCluster convert(String value) {
            try {
                return YtCluster.valueOf(value.toUpperCase());
            } catch (IllegalArgumentException exc) {
                throw new ParameterException("\"" + getOptionName() + "\": " + exc.getMessage());
            }
        }
    }

    @Parameter(
            names = "--yt-path",
            required = true,
            description = "Base path on YT cluster for storing tables data",
            converter = YPathConverter.class
    )
    public YPath ytPath;

    @Parameter(
            names = "--tmp-yt-path",
            required = true,
            description = "Base path on YT cluster for storing tmp tables",
            converter = YPathConverter.class
    )
    public YPath tmpYtPath;

    public static class YPathConverter extends BaseConverter<YPath> {
        public YPathConverter(String optionName) {
            super(optionName);
        }

        @Override
        public YPath convert(String value) {
            try {
                return YPath.simple(value);
            } catch (IllegalArgumentException exc) {
                throw new ParameterException(String.format("\"%s\": %s", getOptionName(), exc.getMessage()));
            }
        }
    }
}

