package ru.yandex.direct.binlogbroker.replicatetoyt.jcommander;

import javax.annotation.ParametersAreNonnullByDefault;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;

import ru.yandex.direct.logging.LoggingInitializerParams;

@ParametersAreNonnullByDefault
@SuppressWarnings("checkstyle:visibilitymodifier")
public class YtWriterParams {
    @Parameter(
            names = {"--skip-erroneous-events"},
            description = "If handling of some event causes exceptions"
                    + " then just warn about exception and skip that event"
    )
    public boolean skipErroneousEvents = false;

    @ParametersDelegate
    public LoggingInitializerParams loggingInitializerParams = new LoggingInitializerParams();

    @ParametersDelegate
    public LogbrokerParams logbrokerParams = new LogbrokerParams();

    @ParametersDelegate
    public YtParams ytParams = new YtParams();
}
