package ru.yandex.direct.binlogbroker.replicatetoyt.models;

import java.time.Duration;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.Preconditions;

@ParametersAreNonnullByDefault
public class LogbrokerConfig {
    private final String host;
    private final String topic;
    private final String clientId;
    private final List<Integer> groups;
    private final Duration timeout;
    private final Duration initTimeout;
    private final int retries;

    private LogbrokerConfig(
            String host, String topic, String clientId, List<Integer> groups, Duration timeout, Duration initTimeout,
            int retryCount
    ) {
        this.host = host;
        this.topic = topic;
        this.clientId = clientId;
        this.groups = groups;
        this.timeout = timeout;
        this.initTimeout = initTimeout;
        this.retries = retryCount;
    }

    public String getHost() {
        return host;
    }

    public String getTopic() {
        return topic;
    }

    public String getClientId() {
        return clientId;
    }

    public List<Integer> getGroups() {
        return groups;
    }

    public Duration getTimeout() {
        return timeout;
    }

    public Duration getInitTimeout() {
        return initTimeout;
    }

    public int getRetries() {
        return retries;
    }

    public static class Builder {
        private String host;
        private String topic;
        private String clientId;
        private List<Integer> groups;
        private Duration timeout;
        private Duration initTimeout;
        private Integer retries;

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setGroups(List<Integer> groups) {
            this.groups = groups;
            return this;
        }

        public Builder setTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder setInitTimeout(Duration initTimeout) {
            this.initTimeout = initTimeout;
            return this;
        }

        public Builder setRetries(int retries) {
            this.retries = retries;
            return this;
        }

        public LogbrokerConfig build() {
            Preconditions.checkState(host != null, "forgotten host");
            Preconditions.checkState(topic != null, "forgotten topic");
            Preconditions.checkState(clientId != null, "forgotten clientId");
            Preconditions.checkState(groups != null, "forgotten groups");
            Preconditions.checkState(timeout != null, "forgotten timeout");
            Preconditions.checkState(initTimeout != null, "forgotten initTimeout");
            Preconditions.checkState(retries != null, "forgotten retries");
            return new LogbrokerConfig(host, topic, clientId, groups, timeout, initTimeout, retries);
        }
    }

}
