package ru.yandex.direct.campkindsimporter;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.jcommander.ParserWithHelp;

public class CampKindsImporterTool {
    private CampKindsImporterTool() {
    }

    public static void main(String[] args) throws IOException {
        CampKindsImporterToolParams params = new CampKindsImporterToolParams();
        ParserWithHelp.parse(CampKindsImporterTool.class.getCanonicalName(), args, params);
        if (params.getJsonLocation().size() != 1) {
            System.err.println("remote JSON is a mandatory singleton parameter");
            System.exit(1);
        }

        URL remoteJsonUrl = params.getJsonLocation().get(0);
        CampKindsImporter<CampaignType> importer = new CampKindsImporter<>(remoteJsonUrl,
                new File(params.getDestRoot()), CampaignType.class.getPackage(), params.getGeneratedClassName(),
                CampaignType.class);
        importer.doImport();
    }
}
