package ru.yandex.direct.campkindsimporter;

import java.net.URL;
import java.util.List;

import com.beust.jcommander.Parameter;

import ru.yandex.direct.jcommander.URLConverter;

public class CampKindsImporterToolParams {
    private String destRoot;
    private String generatedClassName;
    private List<URL> jsonLocation;

    @Parameter(names = {"-j", "--java-sources-dest-root"},
            description = "place generated sources within directory", required = true
    )
    public void setJavaSourcesDestRoot(String destRoot) {
        this.destRoot = destRoot;
    }

    public String getDestRoot() {
        return destRoot;
    }

    @Parameter(description = "Camp types kinds JSON location url", required = true, converter = URLConverter.class)
    public void setJsonLocation(List<URL> location) {
        this.jsonLocation = location;
    }

    public List<URL> getJsonLocation() {
        return jsonLocation;
    }

    @Override
    public String toString() {
        return CampKindsImporterToolParams.class.getSimpleName() + "[" + destRoot + "; " + jsonLocation + "]";
    }

    @Parameter(names = {"-n", "--generated-class-name"},
            description = "generated class name", required = true
    )
    public void setGeneratedClassName(String generatedClassName) {
        this.generatedClassName = generatedClassName;
    }

    public String getGeneratedClassName() {
        return generatedClassName;
    }
}
