package ru.yandex.direct.chassis.app

import org.slf4j.Logger
import ru.yandex.direct.common.jetty.JettyConfig
import ru.yandex.direct.common.jetty.JettyLauncher
import ru.yandex.direct.config.DirectConfig
import ru.yandex.direct.config.DirectConfigFactory
import ru.yandex.direct.jcommander.ParserWithHelp
import ru.yandex.direct.logging.LoggingInitializer
import ru.yandex.direct.logging.LoggingInitializerParams

object ChassisApp {
    private val logger: Logger = LoggingInitializer.getLogger(ChassisApp::class.java)
    const val SERVICE = "direct.chassis"

    @JvmStatic
    fun main(args: Array<String>) {
        val loggingParams = LoggingInitializerParams()
        ParserWithHelp.parse(ChassisApp::class.java.canonicalName, args, loggingParams)
        LoggingInitializer.initialize(loggingParams, SERVICE)

        val directConfig: DirectConfig = DirectConfigFactory.getConfig()
        val jettyConfig = JettyConfig(directConfig.getBranch("jetty"))

        logger.info("start jetty server with config: {}", jettyConfig)

        JettyLauncher.server(jettyConfig)
            .withDefaultWebApp(ChassisApp::class.java.classLoader, "/")
            .run()
    }

}
