package ru.yandex.direct.chassis.app

import org.springframework.context.annotation.AnnotationConfigApplicationContext
import ru.yandex.direct.chassis.configuration.AppConfiguration
import ru.yandex.direct.chassis.entity.aquatests.AquaTestsAutocommentReleasesJob
import ru.yandex.direct.chassis.entity.deploy.DeployNotificationJob
import ru.yandex.direct.chassis.entity.deploy.YaDeployAppReleaseTicketCloser
import ru.yandex.direct.chassis.entity.deploy.YaDeployAppReleaser
import ru.yandex.direct.chassis.entity.regression.restart.AutotestsRestartJob
import ru.yandex.direct.chassis.entity.regression.start.RegressionStartJob
import ru.yandex.direct.chassis.entity.reports.incident.ActionItemsReporter
import ru.yandex.direct.chassis.entity.reports.incident.IncidentsReporter
import ru.yandex.direct.chassis.entity.reports.incident.IncidentsReviewHelper
import ru.yandex.direct.chassis.entity.startrek.AutocommentReleasesJob
import ru.yandex.direct.chassis.entity.startrek.AwaitingReleaseProcessor
import ru.yandex.direct.chassis.entity.startrek.BinlogbrokerTestReport
import ru.yandex.direct.chassis.entity.startrek.ChecklistReleasesJob
import ru.yandex.direct.chassis.entity.startrek.EssRouterTestReport
import ru.yandex.direct.chassis.entity.startrek.IssuesReminderJob
import ru.yandex.direct.chassis.entity.startrek.JobsReleaseToTesting
import ru.yandex.direct.chassis.entity.startrek.JobsTestReport
import ru.yandex.direct.chassis.entity.startrek.OverviewAutocommentReleasesJob
import ru.yandex.direct.chassis.entity.telegram.ReleasesForDeployScheduledCommand
import ru.yandex.direct.chassis.entity.telegram.TelegramPollingBot
import ru.yandex.direct.chassis.entity.telegram.scheduled.FeaturesOwnersNotificationMessage
import ru.yandex.direct.chassis.monitor.TuneReExportWorkers
import ru.yandex.direct.jcommander.ParserWithHelp
import ru.yandex.direct.logging.LoggingInitializer
import ru.yandex.direct.logging.LoggingInitializerParams
import ru.yandex.direct.scheduler.support.DirectJob
import ru.yandex.direct.tracing.TraceHelper

inline fun <reified T> runJob(args: Array<String>) {
    val loggingParams = LoggingInitializerParams()
    ParserWithHelp.parse(T::class.java.canonicalName, args, loggingParams)
    LoggingInitializer.initialize(loggingParams, ChassisApp.SERVICE)

    AnnotationConfigApplicationContext(AppConfiguration::class.java).use { ctx ->
        ctx.getBean(TraceHelper::class.java).guard(T::class.simpleName).use {
            when (val bean = ctx.getBean(T::class.java)) {
                is Runnable -> bean.run()
                is DirectJob -> bean.execute()
                is ActionItemsReporter -> {
                    bean.incrementalUpdateRelations()
                    bean.incrementalUpdateRelatedIssues()
                }
                else -> TODO()
            }
        }
    }
}

object AutotestsRestartJobDebugRunner {
    @JvmStatic
    fun main(args: Array<String>) = runJob<AutotestsRestartJob>(args)
}

object RegressionStartJobDebugRunner {
    @JvmStatic
    fun main(args: Array<String>) = runJob<RegressionStartJob>(args)
}

object AutocommentReleasesJobDebugRunner {
    @JvmStatic
    fun main(args: Array<String>) = runJob<AutocommentReleasesJob>(args)
}

object OverviewAutocommentReleasesJobRunner {
    @JvmStatic
    fun main(args: Array<String>) = runJob<OverviewAutocommentReleasesJob>(args)
}

object YaDeployAppReleaseTicketCloserRunner {
    @JvmStatic
    fun main(args: Array<String>) = runJob<YaDeployAppReleaseTicketCloser>(args)
}

object AquaTestsAutocommentReleasesJobRunner {
    @JvmStatic
    fun main(args: Array<String>) = runJob<AquaTestsAutocommentReleasesJob>(args)
}

object ChecklistReleasesJobDebugRunner {
    @JvmStatic
    fun main(args: Array<String>) = runJob<ChecklistReleasesJob>(args)
}

object YaDeployAppReleaserRunner {
    @JvmStatic
    fun main(args: Array<String>) = runJob<YaDeployAppReleaser>(args)
}

object TuneReExportWorkersRunner {
    @JvmStatic
    fun main(args: Array<String>) = runJob<TuneReExportWorkers>(args)
}

object JobsReleaseToTestingRunner {
    @JvmStatic
    fun main(args: Array<String>) = runJob<JobsReleaseToTesting>(args)
}

object JobsTestReportRunner {
    @JvmStatic
    fun main(args: Array<String>) = runJob<JobsTestReport>(args)
}

object IncidentsReporterRunner {
    @JvmStatic
    fun main(args: Array<String>) = runJob<IncidentsReporter>(args)
}

object ActionItemsReporterRunner {
    @JvmStatic
    fun main(args: Array<String>) = runJob<ActionItemsReporter>(args)
}

object InviteToReviewIncidents {
    @JvmStatic
    fun main(args: Array<String>) = runJob<IncidentsReviewHelper>(args)
}

object AwaitingReleaseProcessorRunner {
    @JvmStatic
    fun main(args: Array<String>) = runJob<AwaitingReleaseProcessor>(args)
}

object ChassisTelegramBotRunner {
    @JvmStatic
    fun main(args: Array<String>) = runJob<TelegramPollingBot>(args)
}

object ReleasesForDeployScheduledCommandRunner {
    @JvmStatic
    fun main(args: Array<String>) = runJob<ReleasesForDeployScheduledCommand>(args)
}

object DeployNotificationJobRunner {
    @JvmStatic
    fun main(args: Array<String>) = runJob<DeployNotificationJob>(args)
}

object EssRouterTestReportRunner {
    @JvmStatic
    fun main(args: Array<String>) = runJob<EssRouterTestReport>(args)
}

object BinlogbrokerTestReportRunner {
    @JvmStatic
    fun main(args: Array<String>) = runJob<BinlogbrokerTestReport>(args)
}

object FeaturesOwnersNotificationRunner {
    @JvmStatic
    fun main(args: Array<String>) = runJob<FeaturesOwnersNotificationMessage>(args)
}

object IssueReminderJobRunner {
    @JvmStatic
    fun main(args: Array<String>) = runJob<IssuesReminderJob>(args)
}
