package ru.yandex.direct.chassis.configuration

import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import ru.yandex.direct.chassis.entity.regression.restart.RegressionConfig
import ru.yandex.direct.chassis.entity.regression.restart.RegressionProfileConfig
import ru.yandex.direct.chassis.util.startrek.StartrekTag

@Configuration
// ide не осознает kotlin-allopen как часть нашей сборки
@Suppress("ImplicitSubclassInspection")
class AutotestsConfiguration {

    @Bean
    fun api5RegressionConfig() = RegressionConfig(
        app = "java-api5",
        maxRestartCount = 2,
    )

    @Bean
    fun intapiRegressionConfig() = RegressionConfig(
        app = "java-intapi",
        maxRestartCount = 1,
    )

    @Bean
    fun webRegressionConfig() = RegressionConfig(
        app = "java-web",
        maxRestartCount = 1,
        filter = ".*DNA.*".toRegex(),
    )

    @Bean
    fun directRegressionConfig() = RegressionConfig(
        app = "direct",

        // Больше тестов ==> больше вероятность, что отдельный тест упадет не по делу N раз подряд
        maxRestartCount = 5,

        // Полезно, так как количество рестартов довольно большое. Если множество тестов падает стабильно, то можно не
        // тратить на них весь бюджет рестартов, а сразу декларировать падение
        noDiffEnabled = true,

        // Выключаем действия, так как они пока не поддерживают профили
        actionsEnabled = false,

        profiles = listOf(
            RegressionProfileConfig(
                issueTag = StartrekTag.REGRESSION_PERL_API_TAG,
                packNames = setOf(
                    "Autotests Direct.API. Banners",
                    "Autotests Direct.API. Campaigns",
                    "Autotests Direct.API. Clients",
                    "Autotests Direct.API Finance",
                    "Autotests Direct. API Images",
                    "Autotests Direct. API Retargeting",
                    "Autotests Direct.API. Statistics",
                    "Autotests Direct.API. Sandbox",
                    "Autotests Direct.API5. Campaigns",
                    "Autotests Direct.API5. AdImages",
                    "Autotests Direct.API5. Changes",
                    "Autotests Direct.API5 Reports",
                    "Autotests Direct.API5 Reports: back-to-back tests",
                ),
            ),
            RegressionProfileConfig(
                issueTag = StartrekTag.REGRESSION_PERL_INTAPI_TAG,
                packNames = setOf(
                    "Autotests Direct INTAPI",
                    "Autotests Direct BS Transport",
                    "Autotests Direct BS Transport Full Export",
                    "Autotests Direct B2B BS Transport",
                ),
            ),
            RegressionProfileConfig(
                issueTag = StartrekTag.REGRESSION_PERL_CMD_TAG,
                packNames = setOf(
                    "Direct Backend",
                ),
            ),
        ),
    )

}
