package ru.yandex.direct.chassis.configuration

import org.slf4j.LoggerFactory
import org.springframework.http.HttpStatus
import org.springframework.http.ResponseEntity
import org.springframework.web.bind.annotation.ControllerAdvice
import org.springframework.web.bind.annotation.ExceptionHandler
import org.springframework.web.bind.annotation.ResponseBody
import java.lang.Exception

@ControllerAdvice
// ide не осознает kotlin-allopen как часть нашей сборки
@Suppress("ImplicitSubclassInspection")
class ChassisExceptionHandler {
    private val logger = LoggerFactory.getLogger(ChassisExceptionHandler::class.java)

    @ExceptionHandler
    @ResponseBody
    fun defaultErrorHandler(e: Exception?): ResponseEntity<String?> {
        logger.error("Internal server error", e)
        return ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR)
    }
}
