package ru.yandex.direct.chassis.configuration

import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import org.springframework.context.annotation.Import
import org.springframework.web.filter.CompositeFilter
import org.springframework.web.servlet.config.annotation.EnableWebMvc
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer
import org.springframework.web.servlet.view.freemarker.FreeMarkerViewResolver
import ru.yandex.direct.common.configuration.LoggingConfiguration
import ru.yandex.direct.common.tracing.TraceContextFilter
import javax.servlet.Filter

@Configuration
@EnableWebMvc
@Import(
    AppConfiguration::class,
    LoggingConfiguration::class,
)
// ide не осознает kotlin-allopen как часть нашей сборки
@Suppress("ImplicitSubclassInspection")
class ChassisWebAppConfiguration : WebMvcConfigurer {

    @Bean("chassisFilter")
    fun chassisFilter(
        traceContextFilter: TraceContextFilter,
    ): Filter {
        return CompositeFilter().also {
            it.setFilters(
                listOf(
                    traceContextFilter,
                )
            )
        }
    }

    @Bean
    fun freeMarkerConfigurer() : FreeMarkerConfigurer {
        return FreeMarkerConfigurer().apply {
            setTemplateLoaderPath("/WEB-INF/views/")
            setDefaultEncoding("utf-8")
        }
    }

    @Bean
    fun freeMarkerViewResolver(): FreeMarkerViewResolver {
        return FreeMarkerViewResolver().apply {
            isCache = true
            setSuffix(".ftl")
            setContentType("text/html;charset=UTF-8")
        }
    }
}
