package ru.yandex.direct.chassis.configuration

import org.springframework.beans.factory.annotation.Value
import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import org.springframework.context.annotation.Import
import org.springframework.context.annotation.Primary
import ru.yandex.direct.chassis.entity.reports.incident.ActionItemsReporter
import ru.yandex.direct.chassis.entity.reports.incident.IncidentsReporter
import ru.yandex.direct.chassis.util.StartrekTools
import ru.yandex.direct.chassis.util.cf
import ru.yandex.direct.chassis.util.startrek.StartrekField
import ru.yandex.direct.common.configuration.CommonConfiguration
import ru.yandex.direct.liveresource.provider.LiveResourceFactoryBean
import ru.yandex.startrek.client.Session
import ru.yandex.startrek.client.model.Field

val STARTREK_CUSTOM_FIELDS = mapOf(
    "javaWebTesting" to Field.Schema.scalar(Field.Schema.Type.STRING, false),
    "javaApiTesting" to Field.Schema.scalar(Field.Schema.Type.STRING, false),
    "javaIntapiTesting" to Field.Schema.scalar(Field.Schema.Type.STRING, false),
    "javaJobsTesting" to Field.Schema.scalar(Field.Schema.Type.STRING, false),
    "javaLogviewerTesting" to Field.Schema.scalar(Field.Schema.Type.STRING, false),

    StartrekField.AFFECTED_APPS to Field.Schema.array(Field.Schema.Type.STRING),
    StartrekField.TESTED_APPS to Field.Schema.array(Field.Schema.Type.STRING),

    StartrekField.HOW_TO_TEST to Field.Schema.scalar(Field.Schema.Type.STRING, false),

    StartrekField.NUMBER_OF_CRM_TICKETS to Field.Schema.array(Field.Schema.Type.UNKNOWN),
    StartrekField.NUMBER_OF_USERS to Field.Schema.scalar(Field.Schema.Type.INTEGER, false),
    StartrekField.NUMBER_OF_COMPLAINTS to Field.Schema.scalar(Field.Schema.Type.INTEGER, false),
    StartrekField.SANDBOX_BUILD_TASK to Field.Schema.scalar(Field.Schema.Type.STRING, false),
)

const val MAINTENANCE_HELPERS_TRACKER_BEAN = "RobotDirectSustainTrackerClient"

@Configuration
@Import(CommonConfiguration::class)
// ide не осознает kotlin-allopen как часть нашей сборки
@Suppress("ImplicitSubclassInspection")
class StartrekConfiguration {
    @Bean
    @Primary
    fun startrekSession(
        @Value("\${startrek.startrek_api_url}") apiUrl: String,
        @Value("\${startrek.chassis.token}") tokenResource: String,
        liveResourceFactoryBean: LiveResourceFactoryBean
    ): Session {
        val token = liveResourceFactoryBean[tokenResource].content.trim()
        return StartrekTools.createClient(apiUrl, token, STARTREK_CUSTOM_FIELDS.cf)
    }

    @Bean(MAINTENANCE_HELPERS_TRACKER_BEAN)
    fun maintenanceHelperSession(
        @Value("\${startrek.startrek_api_url}") apiUrl: String,
        @Value("\${maintenance-helpers.startrek_token_file}") tokenResource: String,
        liveResourceFactoryBean: LiveResourceFactoryBean
    ) : Session {
        val token = liveResourceFactoryBean.get(tokenResource).content.trim()
        val cf = StartrekTools.mergeCustomFields(
            listOf(
                IncidentsReporter.getCustomFields(),
                ActionItemsReporter.getCustomFields(),
                mapOf("marked" to Field.Schema.array(Field.Schema.Type.USER)),
            )
        )
        return StartrekTools.createClient(apiUrl, token, cf)
    }
}
