package ru.yandex.direct.chassis.controller

import com.fasterxml.jackson.core.type.TypeReference
import org.slf4j.LoggerFactory
import org.springframework.http.MediaType
import org.springframework.web.bind.annotation.PostMapping
import org.springframework.web.bind.annotation.RequestMapping
import org.springframework.web.bind.annotation.RequestParam
import org.springframework.web.bind.annotation.ResponseBody
import org.springframework.web.bind.annotation.RestController
import ru.yandex.direct.chassis.entity.buildbot.BuildbotPacket
import ru.yandex.direct.chassis.entity.buildbot.BuildbotService
import ru.yandex.direct.utils.JsonUtils

/**
 * Сюда ходит buildbot с результатами запуска перловых тестов.
 * [Пример запроса](https://paste.yandex-team.ru/5717943)
 */
@RestController
@RequestMapping("/buildbot", produces = [MediaType.APPLICATION_JSON_VALUE])
@ResponseBody
class BuildbotController(
    private val buildbotService: BuildbotService,
) {
    private val logger = LoggerFactory.getLogger(BuildbotController::class.java)

    @PostMapping("/status", consumes = [MediaType.APPLICATION_FORM_URLENCODED_VALUE])
    fun postStatus(@RequestParam("packets") packetsJson: String) {
        logger.info("Buildbot events: {}", packetsJson)

        val packets = JsonUtils.fromJson(
            packetsJson,
            object : TypeReference<List<BuildbotPacket>>() {}
        )

        buildbotService.process(packets)
    }

}
