package ru.yandex.direct.chassis.controller

import org.springframework.http.MediaType
import org.springframework.stereotype.Controller
import org.springframework.ui.ModelMap
import org.springframework.web.bind.annotation.*
import ru.yandex.direct.chassis.entity.deploy.ReleasesDeployQueueRepository
import ru.yandex.direct.dbschema.chassis.enums.ReleasesDeployQueueStatus

@Controller
@RequestMapping("/deploy", produces = [MediaType.TEXT_HTML_VALUE])
open class DeployReleaseController(
    val repository: ReleasesDeployQueueRepository
) {
    @GetMapping
    open fun indexPage(@RequestParam("ticket") ticket: String, modelMap: ModelMap): String {
        // TODO : проверить тикет, существует ли он, и является ли он релизным, можно ли его выкладывать
        // TODO : получить текущего пользователя (из yandex-team) и проверить его права
        //  если прав нет, то не выводить ему кнопки для действий
        modelMap["ticket"] = ticket
        val release = repository.getByTicket(ticket)
        return if (release == null) {
            "create-form"
        } else {
            modelMap["release"] = release
            "view-status"
        }
    }

    @PostMapping("add")
    open fun addReleaseToQueue(@RequestParam("ticket") ticket: String): String {
        // TODO : проверить всё, что проверяется в indexPage
        repository.addToQueue(ticket, "")  // TODO : login
        return "redirect:/deploy?ticket=${ticket}"
    }

    @PostMapping("cancel")
    open fun cancelRelease(@RequestParam("ticket") ticket: String): String {
        // TODO : проверить всё, что проверяется в indexPage
        repository.updateStatus(ticket, ReleasesDeployQueueStatus.Cancelled)
        return "redirect:/deploy?ticket=${ticket}"
    }
}
