package ru.yandex.direct.chassis.entity.aquatests

import ru.yandex.startrek.client.model.Comment
import ru.yandex.startrek.client.model.Issue
import java.time.Instant

data class AquaTestIssueInfo (
    val ticket: Issue,
    val comments: List<AquaTestCommentInfo>,
)

data class AquaTestCommentInfo(
    val version: String,
    val comment: Comment? = null,
    val commentData: AquaTestCommentData = AquaTestCommentData(),
)

data class AquaTestCommentData(
    val afterDeployLaunches: List<AquaTestLaunch> = listOf(),
    val beforeDeployLaunches: List<AquaTestLaunch> = listOf(),
)

data class AquaTestLaunch(
    val startTime: Instant,
    val stopTime: Instant,
    val stopTimeIsEstimated: Boolean,
    val totalTests: Int,
    val passedTests: Int,
    val runningTests: Int,
    val revokedTests: Int,
    val failedTests: Int,
    val status: AquaTestLaunchStatus,
    val launchUrl: String,
)

enum class AquaTestLaunchStatus(val description: String) {
    UNKNOWN("Неизвестен"),
    RUNNING("Выполняется"),
    FINISHED("Выполнен"),
    FAILED("Ошибка"),
    REVOKED("Отменен"),
}
