package ru.yandex.direct.chassis.entity.buildbot

import ru.yandex.direct.dbschema.chassis.enums.BuildbotBuildsStatus
import java.time.LocalDateTime
import kotlin.reflect.KProperty

/**
 * Запись об одной сборке, которая хранится в базе chassis
 */
data class BuildInfo(
    val id: Long = -1,
    val builder: String,
    val buildNumber: Long,
    val branch: String,
    val revision: Long,
    val status: BuildbotBuildsStatus,
    val statusText: String,
    val commitMessage: String?,
    val startTime: LocalDateTime,
    val endTime: LocalDateTime,

    /**
     * Изначально `false`, если билд был перезапущен, устанавливается в `true`.
     * Используется как признак, что надо дождаться сборки
     */
    val restarted: Boolean,
)

/**
 * Данные, присылаемые от buildbot в ручку
 */
data class BuildbotPacket(
    val id: String,
    val event: String,
    val payload: BuildbotPayload?,
)

data class BuildbotPayload(
    val build: BuildbotBuild?,
)

data class BuildbotBuild(
    val text: List<String?>?,
    val builderName: String?,
    val properties: List<List<Any?>>,
    val times: List<Double>,
    val sourceStamps: List<BuildBotSourceStamp>?,
) {
    val branch: String? by BuildbotProperty
    val revision: String? by BuildbotProperty
    val buildnumber: String? by BuildbotProperty
}

/**
 * Проперти билда зачем-то приходят как таплы (массивы) из трех элементов.
 * Делаем их получение удобней
 */
object BuildbotProperty {
    operator fun getValue(build: BuildbotBuild, property: KProperty<*>): String? {
        for (prop in build.properties) {
            if (prop[0] == property.name) {
                return prop[1]?.toString()?.ifEmpty { null }
            }
        }
        return null
    }
}

data class BuildBotSourceStamp(
    val changes: List<BuildBotChange>?,
)

data class BuildBotChange(
    val comments: String?,
)
