package ru.yandex.direct.chassis.entity.deploy.model

import ru.yandex.yp.client.api.Autogen.TDeployTicket
import ru.yandex.yp.client.api.Autogen.TRelease
import ru.yandex.yp.client.api.Autogen.TStage
import ru.yandex.yp.client.api.EConditionStatus
import ru.yandex.yp.client.api.TDeployUnitStatus

data class DeployInfo(
    val stage: TStage,
    val deployUnitStatus: TDeployUnitStatus,
    val version: String,
    val release: TRelease,
    val deployTicket: TDeployTicket,
) {
    fun isNew() =
        !isInProgress() && !isFinished()

    fun isInProgress() =
        deployTicket.status.progress.inProgress.status == EConditionStatus.CS_TRUE

    fun isFinished() =
        deployTicket.status.progress.closed.status == EConditionStatus.CS_TRUE

    fun isSuccessful() =
        deployTicket.status.patchesMap.values.all { patchStatus ->
            patchStatus.progress.success.status == EConditionStatus.CS_TRUE
        }

    fun isWaitingForApprove() =
        deployUnitStatus.latestDeployedRevision != deployUnitStatus.targetRevision
            && deployUnitStatus.currentTarget.deploySettings.clusterSequenceList.any { it.needApproval }
            && deployUnitStatus.progress.podsReady == deployUnitStatus.progress.podsTotal
}

