package ru.yandex.direct.chassis.entity.regression.restart

import ru.yandex.direct.chassis.util.aqua.LaunchStatus
import ru.yandex.direct.chassis.util.aqua.Suite
import java.time.Duration
import java.time.Instant

/**
 * Конфиг рестарта тестов для релиза приложения `app`
 */
data class RegressionConfig(
    /**
     * Название приложение в `direct-apps.conf.yaml`, например `java-api5`
     */
    val app: String,

    /**
     * Лимит количество рестартов одного пака (всего пак будет запущен `maxRestartCount + 1` раз)
     */
    val maxRestartCount: Int,

    /**
     * Если `true`, то рестарт пака может быть остановлен,
     * если последний перезапуск не уменьшил множество упавших тестов
     */
    val noDiffEnabled: Boolean = false,

    /**
     * Тикеты, summary которых матчится этим выражением, не будут считаться регрессионными
     */
    val filter: Regex? = null,

    /**
     * Если `true`, то доступны действия над состоянием растарта. Например, с помощью добавления тега тикета
     */
    val actionsEnabled: Boolean = true,

    /**
     * Профили, на которые разделяются запущенные в релизе паки
     */
    val profiles: List<RegressionProfileConfig>? = null,
)

/**
 * Профиль внутри одного релиза. Позволяет иметь несколько регрессионных тикетов связанных с одним тегом аквы
 */
data class RegressionProfileConfig(
    /**
     * Тикеты с таким тегом будут принадлежать профилю
     */
    val issueTag: String,

    /**
     * Названия паков, принадлежащих профилю
     */
    val packNames: Set<String>,
)

/**
 * Информация о регрессии конкретного релиза (таблица autotests_state)
 */
data class ReleaseRegressionInfo(
    val app: String,
    val releaseKey: String,
    val tag: String,
    val packs: List<PackRestartState>,
)

/**
 * Информация о рестарте пака
 */
data class PackRestartState(
    val packId: String,
    val name: String,
    val restartCount: Int = 0,
    val stopReason: StopReason? = null,
    val lastFinishedLaunch: PackLaunch? = null,
)

/**
 * Причина, по которой больше не рестартим пак
 */
enum class StopReason {
    PASSED,
    COUNT_LIMIT_REACHED,
    NO_DIFF,
}

/**
 * Информация о запуске пака
 */
data class PackLaunch(
    val name: String,
    val packId: String,
    val launchId: String,
    val startTime: Instant,
    val status: LaunchStatus,
    val failedSuites: Set<SuiteInfo>,
)

/**
 * Описание теста
 */
data class SuiteInfo(
    val id: String,
    val name: String,
)
