package ru.yandex.direct.chassis.entity.regression.start

import ru.yandex.direct.chassis.util.abc.ScheduleSlug
import ru.yandex.direct.chassis.util.startrek.StartrekQueue
import ru.yandex.direct.chassis.util.startrek.StartrekTag

val RELEASE_TYPES = listOf(
    ReleaseType(
        app = "perl",
        components = listOf("Releases: Direct"),
        issueTemplates = listOf(
            RegressionIssueTemplate(
                queue = StartrekQueue.DIRECT,
                summary = "API: Запуск и анализ регрессионных автотестов в релизе %s",
                description = """
                    Banners:
                    https://aqua.yandex-team.ru/#/launches?skip=0&limit=20&packId=52a08d75e4b07352a7405ebb

                    Campaigns(API4):
                    https://aqua.yandex-team.ru/#/launches?skip=0&limit=20&packId=527b77d5e4b0706bf42324ab

                    Clients:
                    https://aqua.yandex-team.ru/#/launches?skip=0&limit=20&packId=52a160b7e4b07352a742e74d

                    Finance:
                    https://aqua.yandex-team.ru/#/launches?skip=0&limit=20&packId=52a6b93ce4b07758044b4149

                    Images:
                    https://aqua.yandex-team.ru/#/launches?skip=0&limit=20&packId=5204f071e4b06990cc369e34

                    API4.Retargeting:
                    https://aqua.yandex-team.ru/#/launches?skip=0&limit=20&packId=520e05e4e4b007a8383fcfab

                    Stat:
                    https://aqua.yandex-team.ru/#/launches?skip=0&limit=20&packId=52a87a2be4b07758045001f4

                    Sandbox:
                    https://aqua.yandex-team.ru/#/launches?skip=0&limit=20&packId=54228c24e4b0d5d01094a050

                    API5.Campaigns
                    https://aqua.yandex-team.ru/#/launches?skip=0&limit=20&packId=55ed2fcee4b05733565024ce

                    API5.AdImages
                    https://aqua.yandex-team.ru/#/launches?skip=0&limit=20&packId=56d4208be4b08948c4829dfe

                    Changes:
                    https://aqua.yandex-team.ru/#/launches?skip=0&limit=20&packId=5565fc6be4b069c629b25e0c

                    Reports:
                    https://aqua.yandex-team.ru/#/launches?skip=0&limit=20&packId=57fcdbe5e4b0717fa1c2390f

                    Reports (back-to-back) — ((https://wiki.yandex-team.ru/direct/api/duty/restart-reports-b2b/ как перезапускать)):
                    https://aqua.yandex-team.ru/#/launches?skip=0&limit=20&packId=589cc079e4b05385ac693176
                """.trimIndent(),
                tags = listOf(StartrekTag.REGRESSION_PERL_API_TAG),
                duty = ScheduleSlug.DIRECT_NO_PRODUCTION_DUTY,
            ),
            RegressionIssueTemplate(
                queue = StartrekQueue.DIRECT,
                summary = "INTAPI, Транспорт БК, Транспорт в Модерацию: Запуск и анализ регрессионных автотестов в релизе %s",
                description = """
                    !!Если в релизе хотфиксят транспорт в БК — паки тестов BS Transport и BS Transport B2B нужно прогонять заново **ПОЛНОСТЬЮ**.!!
                    &nbsp;
                    __INTAPI:__
                    https://aqua.yandex-team.ru/#/launches?skip=0&limit=20&packId=522487b2e4b06176345512d8

                    __BS Transport:__
                    https://aqua.yandex-team.ru/#/launches?skip=0&limit=20&packId=5509b4f7e4b07e43030816b9

                    __BS Transport Full Export:__
                    https://aqua.yandex-team.ru/#/launches?skip=0&limit=20&packId=5822e550e4b0fdea1abc8361

                    __BS Transport B2B:__
                    https://aqua.yandex-team.ru/#/launches?skip=0&limit=20&packId=582ac528e4b0717fa1c5937f
                """.trimIndent(),
                tags = listOf(StartrekTag.REGRESSION_PERL_INTAPI_TAG),
                duty = ScheduleSlug.DIRECT_NO_PRODUCTION_DUTY,
            ),
            RegressionIssueTemplate(
                queue = "DIRECT",
                summary = "Запуск и анализ регрессионных автотестов cmd в релизе %s",
                description = """
                    Direct Backend
                    https://aqua.yandex-team.ru/#/launches?skip=0&limit=20&packId=5423ecb5e4b0d5d01094a2f7
                """.trimIndent(),
                tags = listOf(StartrekTag.REGRESSION_PERL_CMD_TAG),
                duty = ScheduleSlug.DIRECT_NO_PRODUCTION_DUTY,
            ),
        ),
        jenkinsJob = "direct-test-ci/job/run_release_tests",
    ),
    ReleaseType(
        app = "java_api5",
        components = listOf("Releases: JavaDirect", "App: java_api5"),
        issueTemplates = listOf(
            RegressionIssueTemplate(
                queue = StartrekQueue.DIRECT,
                summary = "API: Запуск и анализ регрессионных автотестов в релизе %s",
                tags = listOf("direct_release_java_api"),
            ),
        ),
        jenkinsJob = "direct-test-ci/job/run_java_release_tests",
        jenkinsParams = mapOf("serviceTag" to "java_api5"),
    ),
    ReleaseType(
        app = "java_intapi",
        components = listOf("Releases: JavaDirect", "App: java_intapi"),
        issueTemplates = listOf(
            RegressionIssueTemplate(
                queue = StartrekQueue.TESTIRT,
                summary = "INTAPI: Запуск и анализ регрессионных автотестов в релизе %s",
                tags = listOf("direct_release_java_intapi"),
            ),
        ),
        jenkinsJob = "direct-test-ci/job/run_java_release_tests",
        jenkinsParams = mapOf("serviceTag" to "java_intapi"),
    ),
    ReleaseType(
        app = "java_web",
        components = listOf("Releases: JavaDirect", "App: java_web"),
        issueTemplates = listOf(
            RegressionIssueTemplate(
                queue = StartrekQueue.TESTIRT,
                summary = "Запуск и анализ регрессионных автотестов веб-интерфейса в релизе %s",
                description = """
                    Direct Java Web Api
                """.trimIndent(),
                tags = listOf("direct_release_java_web"),
            ),
            RegressionIssueTemplate(
                queue = StartrekQueue.DIRECT,
                summary = "Запуск и анализ регрессионных автотестов DNA в релизе %s",
                tags = listOf("dna_launch_in_java_web"),
                duty = ScheduleSlug.DNA_AUTOTEST,
                needAquaComment = false,
            ),
        ),
        jenkinsJob = "direct-test-ci/job/run_java_release_tests",
        jenkinsParams = mapOf("serviceTag" to "java_web"),
    ),
    ReleaseType(
        app = "dna",
        components = listOf("App: dna"),
        issueTemplates = listOf(
            RegressionIssueTemplate(
                queue = StartrekQueue.DIRECT,
                summary = "Запуск и анализ регрессионных автотестов DNA в релизе %s",
                description = "Полная регрессия",
                tags = listOf("direct_release_front_dna"),
                components = listOf("D2: UI Integration Tests"),
                duty = ScheduleSlug.DNA_AUTOTEST,
                needAquaComment = false,
            ),
        ),
    ),
)
