package ru.yandex.direct.chassis.entity.release.model

/**
 * Проблема, потенциально мешающая выкладке релиза
 */
data class ReleaseError(
    val severity: Severity,
    val text: String,
) {
    companion object {
        fun warn(text: String) = ReleaseError(Severity.WARN, text)
        fun error(text: String) = ReleaseError(Severity.ERROR, text)
    }

    enum class Severity(val icon: String) {
        /**
         * Что-то не так, стоит убедиться что все хорошо
         */
        WARN(" ⚠️ "),

        /**
         * Проблема запрещающая выкладку
         */
        ERROR(" ❗️"),
    }

    override fun toString() = "${severity.icon}$text"
}
