package ru.yandex.direct.chassis.entity.reports.incident

import ru.yandex.direct.scheduler.Hourglass
import ru.yandex.direct.scheduler.HourglassStretchPeriod
import ru.yandex.direct.scheduler.support.DirectJob

@Hourglass(periodInSeconds = 60 * 60)
@HourglassStretchPeriod(3 * 60)
class ActionItemsListUpdater(private val tool: ActionItemsReporter) : DirectJob() {
    override fun execute() {
        tool.incrementalUpdateRelations()
    }
}

@Hourglass(periodInSeconds = 6 * 60)
@HourglassStretchPeriod(10 * 60)
class RelatedIssuesUpdater(private val tool: ActionItemsReporter) : DirectJob() {
    override fun execute() {
        tool.incrementalUpdateRelatedIssues()
    }
}
