package ru.yandex.direct.chassis.entity.reports.incident;

import java.time.Instant;
import java.util.Set;

import ru.yandex.direct.chassis.util.startrek.StartrekQueue;
import ru.yandex.direct.chassis.util.startrek.StartrekTag;

class IncidentRelatedIssue extends BaseIssue {
    static final String INCIDENT_RESPONSE = "Incident Response";

    private static final Set<String> NOT_AI_QUEUES = Set.of(
            StartrekQueue.SPI,
            "YTINCIDENTS",
            StartrekQueue.TEST,
            StartrekQueue.TESTSPI
    );

    private String incident;
    private Instant incidentDetectTime;

    IncidentRelatedIssue() {
        super();
    }

    IncidentRelatedIssue(IncidentRelatedIssue other) {
        super(other);
        this.incident = other.incident;
    }

    boolean isActionItem() {
        return hasTag(StartrekTag.DIRECT_INCIDENT_RESPONSE)
                || hasComponent(INCIDENT_RESPONSE)
                || getQueue().equals(StartrekQueue.SPPROBLEM) && hasTag(StartrekTag.SPI_PROBLEM)
                // некоторые товарищи пишут чужие инциденты как свои AI
                // не пытаемся с этим бороться, игнорируем
                || hasTag(StartrekTag.SPI_ACTION_ITEM) && !NOT_AI_QUEUES.contains(getQueue());
    }

    String getIncident() {
        return incident;
    }

    void setIncident(String incident) {
        this.incident = incident;
    }

    public Instant getIncidentDetectTime() {
        return incidentDetectTime;
    }

    public void setIncidentDetectTime(Instant incidentDetectTime) {
        this.incidentDetectTime = incidentDetectTime;
    }

    @Override
    public String toString() {
        return "IncidentRelatedIssue{" +
                "key='" + getKey() + "'," +
                "incident='" + incident + '\'' +
                '}';
    }
}
