package ru.yandex.direct.chassis.entity.reports.incident

import ru.yandex.direct.scheduler.Hourglass
import ru.yandex.direct.scheduler.HourglassStretchPeriod
import ru.yandex.direct.scheduler.support.DirectJob

@Hourglass(periodInSeconds = 15 * 60)
@HourglassStretchPeriod(5 * 60)
class ScoreIncidentsToMarkUp(private val tool: IncidentsScoring) : DirectJob() {
    override fun execute() {
        tool.scoreIncidentsToMarkUp()
    }
}

@Hourglass(periodInSeconds = 2 * 60 * 60)
@HourglassStretchPeriod(5 * 60)
class ScoreIncidentsToFigureOut(private val tool: IncidentsScoring) : DirectJob() {
    override fun execute() {
        tool.scoreIncidentsToFigureOut()
    }
}

@Hourglass(periodInSeconds = 3 * 60 * 60)
@HourglassStretchPeriod(20 * 60)
class IncidentsStat(private val tool: IncidentsScoring) : DirectJob() {
    override fun execute() {
        tool.allStat()
        tool.spiStat()
        tool.directStat2021Q2()
        tool.directStat2021Q4()
        tool.directStat2022Q2()
    }
}
