package ru.yandex.direct.chassis.entity.sandbox

import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming

enum class ReleaseSubject {
    cancelled,
    unsatble,
    testing,
    prestable,
    stable,
}

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class ReleaseRequest(
    val subject: ReleaseSubject,
    val taskId: Long,
    val type: ReleaseSubject,
)

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class ReleaseInfo(
    val subject: ReleaseSubject,
    val taskId: Long,
    val type: ReleaseSubject,
)

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class ReleasesInfoItems(
    val items: List<ReleaseInfo>,
)

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class ReleaseTaskResponse(
    val message: String?,
    val reason: String?,
)
