package ru.yandex.direct.chassis.entity.startrek

import ru.yandex.bolts.collection.impl.ReadOnlyArrayList
import ru.yandex.direct.chassis.util.startrek.StartrekField
import ru.yandex.direct.chassis.util.startrek.StartrekHelper.Companion.field
import ru.yandex.startrek.client.model.Issue
import ru.yandex.startrek.client.model.IssueUpdate
import ru.yandex.startrek.client.model.UserRef

var Issue.howToTest: String?
    get() = field(StartrekField.HOW_TO_TEST)
    set(value) { update(IssueUpdate.set(StartrekField.HOW_TO_TEST, value).build()) }

val Issue.qaEngineer: UserRef?
    get() = field(StartrekField.QA_ENGINEER)

val Issue.affectedApps: Set<String>
    get() = try {
        get<ReadOnlyArrayList<String>>(StartrekField.AFFECTED_APPS).toSet()
    } catch (e: RuntimeException) {
        emptySet()
    }

val Issue.testedApps: Set<String>
    get() = try {
        get<ReadOnlyArrayList<String>>(StartrekField.TESTED_APPS).toSet()
    } catch (e: RuntimeException) {
        emptySet()
    }

val Issue.commentSummonee: UserRef?
    get() = try {
        assignee.getOrElse(createdBy)
    } catch (e: RuntimeException) {
        null
    }

fun Issue.hasAllDeployedTags(appNameToDeployedTag: Map<String?, String?>): Boolean {
    val necessaryDeployedTags = affectedApps.map { appNameToDeployedTag[it] }
    return necessaryDeployedTags.minus(tags).isEmpty()
}
