package ru.yandex.direct.chassis.entity.startrek

/**
 * Тег тикетов c автотестами или юнит-тестами
 */
const val DIRECT_RELEASE_TESTS_TICKET_TAG = "direct_release_tests"

fun allOkQuery(trackerAppName: String, releaseKey: String) = """
                Status: Closed, "Beta-tested", "Awaiting Release"
                AND "Affected Apps": !empty()
                AND ("Affected Apps": !$trackerAppName OR "Tested Apps": $trackerAppName)
                AND Relates: $releaseKey
                """.trimIndent()

fun wontTestQuery(releaseKey: String) = """
                "Affected Apps": none
                AND Relates: $releaseKey
                """.trimIndent()

/**
 * Запрос тикетов для очереди "Разобраться" в релизах.
 */
fun toReviewQuery(trackerAppName: String, releaseKey: String) = """
                (
                Status: !Closed AND Status: !"Beta-tested" AND Status: !"Awaiting Release"
                OR "Affected Apps": empty()
                OR Status: Closed AND "Affected Apps": $trackerAppName AND "Tested Apps": !$trackerAppName
                ) AND Relates: $releaseKey
                AND (Queue: DIRECT OR Queue: DIRECTMIGR)
                AND Tags: !$DIRECT_RELEASE_TESTS_TICKET_TAG
                AND Tags: !кроссрелизные_зависимости
                AND Type: !Release
                """.trimIndent()

/**
 * Запрос тикетов из соседних очередей, попавших в релиз.
 */
fun toExternalReviewQuery(trackerAppName: String, releaseKey: String) = """
                (
                Status: !Closed AND Status: !"Beta-tested" AND Status: !"Awaiting Release"
                OR "Affected Apps": empty()
                OR Status: Closed AND "Affected Apps": $trackerAppName AND "Tested Apps": !$trackerAppName
                ) AND Relates: $releaseKey
                AND Tags:! $DIRECT_RELEASE_TESTS_TICKET_TAG
                AND (Queue: !DIRECT AND Queue: !DIRECTMIGR)
                """.trimIndent()

fun toTestQuery(trackerAppName: String, releaseKey: String) = """
                Status: "Beta-tested", "Awaiting Release"
                AND "Affected Apps": $trackerAppName
                AND "Tested Apps": !$trackerAppName
                AND Tags:! $DIRECT_RELEASE_TESTS_TICKET_TAG
                AND Relates: $releaseKey
                """.trimIndent()
