package ru.yandex.direct.chassis.entity.telegram

import ru.yandex.direct.chassis.entity.telegram.model.Command
import ru.yandex.direct.chassis.util.nonNullValues
import ru.yandex.direct.staff.client.StaffClient
import ru.yandex.startrek.client.model.Issue

object TelegramUtils {
    fun htmlLink(text: String, url: String) =
        """<a href="$url">$text</a>"""

    fun issueLink(issue: Issue): String =
        htmlLink(issue.key, "https://st.yandex-team.ru/${issue.key}")

    /**
     * Если текст начинается на команду, возвращает её. Дополнительно проверяет, что команда упоминает нужного бота,
     * если упоминание есть
     */
    fun parseCommand(text: String): Command? {
        val parts: List<String> = text.split(" ")

        val commandPart: String = parts.firstOrNull()
            ?: return null
        if (!commandPart.startsWith("/")) {
            return null
        }

        val args: List<String> = parts.drop(1)

        val commandText = commandPart.drop(1)
        if ('@' in commandText) {
            val (command, target) = commandText.split('@', limit = 2)
            return Command(command, target, args)
        } else {
            return Command(commandText, null, args)
        }
    }

    fun getTelegramLogins(staffClient: StaffClient, staffLogins: Collection<String>): Set<String> {
        val selector = staffLogins.joinToString(" or ") { "login == \"$it\"" }
        val accounts = staffClient.getStaffUsers(selector, "accounts")
        return accounts
            .flatMap { it.accounts }
            .filter { it.type == "telegram" }
            .filter { !it.private }
            .map { it.value }
            .toSet()
    }

    fun getTelegramLoginsByStaffLogin(staffClient: StaffClient, staffLogins: Collection<String>): Map<String, String?> {
        val selector = staffLogins.joinToString(" or ") { "login == \"$it\"" }
        val accounts = staffClient.getStaffUsers(selector, "login,accounts")
        return accounts
            .associate { it.login to it.accounts}
            .mapValues { (_, accounts) ->
                accounts
                    .find { !it.private && it.type == "telegram" }
                    ?.value
            }
            .nonNullValues()
    }
}
