package ru.yandex.direct.chassis.entity.telegram.command

import org.springframework.stereotype.Component
import ru.yandex.direct.chassis.entity.telegram.model.AllowedChats
import ru.yandex.direct.chassis.entity.telegram.model.Command
import ru.yandex.direct.telegram.client.TelegramClient
import ru.yandex.direct.telegram.client.api.Message
import ru.yandex.direct.telegram.client.api.ParseMode

@Component
class ChatIdCommand(
    private val telegram: TelegramClient,
) : CommandHandler {
    override val command = "chat_id"

    override val allowedChats = AllowedChats.any()

    override fun handle(update: Message, command: Command) {
        telegram.sendMessage(
            update.chat.id,
            "chat_id: <code>${update.chat.id}</code>",
            parseMode = ParseMode.HTML,
        )
    }
}
