package ru.yandex.direct.chassis.entity.telegram.command

import ru.yandex.direct.chassis.entity.telegram.handler.MessageHandler
import ru.yandex.direct.chassis.entity.telegram.model.AllowedChats
import ru.yandex.direct.chassis.entity.telegram.model.Command
import ru.yandex.direct.telegram.client.api.ChatType
import ru.yandex.direct.telegram.client.api.Message

interface CommandHandler {
    /**
     * Команда, которая должна обрабатываться этим [CommandHandler]
     */
    val command: String

    /**
     * Определяет в каких чатах команда может быть обработана этим [CommandHandler]
     */
    val allowedChats: AllowedChats

    fun handle(update: Message, command: Command)
}
