package ru.yandex.direct.chassis.entity.telegram.command

import org.springframework.stereotype.Component
import ru.yandex.direct.chassis.entity.telegram.TelegramChats
import ru.yandex.direct.chassis.entity.telegram.TelegramUtils
import ru.yandex.direct.chassis.entity.telegram.model.AllowedChats
import ru.yandex.direct.chassis.entity.telegram.model.Command
import ru.yandex.direct.chassis.util.startrek.StartrekComponent
import ru.yandex.direct.chassis.util.startrek.StartrekHelper
import ru.yandex.direct.chassis.util.startrek.StartrekStatusKey
import ru.yandex.direct.telegram.client.TelegramClient
import ru.yandex.direct.telegram.client.api.Message
import ru.yandex.direct.telegram.client.api.ParseMode
import ru.yandex.startrek.client.model.Issue

/**
 * Команда выводит список тикетов, помеченных как postponed action
 */
@Component
class PostponedActionsListCommand(
    private val telegram: TelegramClient,
    private val startrek: StartrekHelper,
) : CommandHandler {
    override val command = "postponed_actions"

    override val allowedChats = AllowedChats.fromChatIds(
        TelegramChats.DIRECT_APP_DUTY,
    )

    override fun handle(update: Message, command: Command) {
        val message = getListPostponedActionsTicketsMessage()
            ?: "Тикетов на отложенные действия не найдено"
        telegram.sendMessage(update.chat.id, message, ParseMode.HTML)
    }

    fun getListPostponedActionsTicketsMessage(): String? {
        val tickets: List<Issue> = startrek.findIssues(
            """
                Components: "${StartrekComponent.POSTPONED_ACTION}"
                Status: ${StartrekStatusKey.OPEN}, ${StartrekStatusKey.NEED_INFO}, ${StartrekStatusKey.IN_PROGRESS}
                "Sort by": key asc
            """.trimIndent()
        )

        if (tickets.isEmpty()) {
            return null
        }

        var message = "⏳ Незакрытые тикеты на отложенные действия:\n"
        message += tickets.joinToString("\n") {
            "${TelegramUtils.issueLink(it)} (${it.summary})"
        }
        return message
    }
}
