package ru.yandex.direct.chassis.entity.telegram.model

import ru.yandex.direct.telegram.client.api.Chat
import ru.yandex.direct.telegram.client.api.ChatType

class AllowedChats(
    private val chatIds: Set<Long> = setOf(),
) {
    companion object {
        fun fromChatIds(vararg chatIds: Long) = AllowedChats(chatIds.toSet())
        fun any() = AllowedChats()
    }

    /**
     * Обработчик может быть вызван в любом чате
     */
    private fun isAny() = chatIds.isEmpty()

    /**
     * Возвращает `true`, если сообщение в чате [chat] может быть обработано независимо от отправителя
     */
    fun isAllowedUnconditionally(chat: Chat): Boolean {
        return chat.id in chatIds
    }

    /**
     * Возвращает `true`, если сообщение в чате [chat] может быть обработано с проверкой пользователя
     */
    fun isAllowedWithUserCheck(chat: Chat): Boolean {
        return isAny() || chat.type == ChatType.PRIVATE
    }
}
