package ru.yandex.direct.chassis.entity.telegram.model

import ru.yandex.direct.ytwrapper.model.YtField
import ru.yandex.direct.ytwrapper.model.YtTableRow

class OwnersDiffTableRow : YtTableRow(listOf(ORIGINAL_OWNER, OUTDATED_NOW, OUTDATED_TWO_WEEKS_AGO, CAN_BE_DELETED_FROM_CODE, SHOULD_BE_ENABLED)){
    val originalOwner: String
        get() = valueOf(ORIGINAL_OWNER)
    val outdatedNow: Long
        get() = valueOf(OUTDATED_NOW)
    val outdatedTwoWeeksAgo: Long
        get() = valueOf(OUTDATED_TWO_WEEKS_AGO)
    val canBeDeletedFromCode: Long
        get() = valueOf(CAN_BE_DELETED_FROM_CODE)
    val shouldBeEnabled: Long
        get() = valueOf(SHOULD_BE_ENABLED)

    companion object {
        private val ORIGINAL_OWNER = YtField("original_owner", String::class.java)
        private val OUTDATED_NOW = YtField("outdated_now", Long::class.java)
        private val OUTDATED_TWO_WEEKS_AGO = YtField("outdated_two_weeks_ago", Long::class.java)
        private val CAN_BE_DELETED_FROM_CODE = YtField("can_be_deleted_from_code", Long::class.java)
        private val SHOULD_BE_ENABLED = YtField("should_be_enabled", Long::class.java)
    }
}
