package ru.yandex.direct.chassis.repository

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import ru.yandex.direct.chassis.model.Commit
import ru.yandex.direct.dbschema.chassis.tables.Commit.COMMIT
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.jooqmapperhelper.InsertHelper

@Component
class CommitRepository @Autowired constructor(var dslContextProvider: DslContextProvider) {

    fun getLastCommit(): Commit? {
        return dslContextProvider.chassis()
            .select(COMMIT.REVISION, COMMIT.TIME)
            .from(COMMIT)
            .orderBy(COMMIT.REVISION.desc())
            .limit(1)
            .fetchOne()?.map {
                Commit()
                    .withRevision(it.get(COMMIT.REVISION))
                    .withTime(it.get(COMMIT.TIME))
            }
    }

    fun addCommits(commits: List<Commit>) {
        if (commits.isEmpty()) return

        val insert = InsertHelper(dslContextProvider.chassis(), COMMIT)
        commits.forEach {
            insert
                .set(COMMIT.REVISION, it.revision)
                .set(COMMIT.TIME, it.time)
                .newRecord()
        }

        insert.execute()
    }

}
