package ru.yandex.direct.chassis.repository

import org.jooq.impl.DSL.max
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import ru.yandex.direct.chassis.model.Hotfix
import ru.yandex.direct.dbschema.chassis.tables.DeployHotfix.DEPLOY_HOTFIX
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.jooqmapperhelper.InsertHelper
import java.time.LocalDateTime

@Component
class DeployHotfixRepository @Autowired constructor(private val dslContextProvider: DslContextProvider){

    fun addHotfixes(hotfixes: List<Hotfix>) {
        if (hotfixes.isEmpty()) return

        val insert = InsertHelper(dslContextProvider.chassis(), DEPLOY_HOTFIX)
        hotfixes.forEach {
            insert
                .set(DEPLOY_HOTFIX.APP, it.app)
                .set(DEPLOY_HOTFIX.RELEASE_TICKET, it.deployTicketKey)
                .set(DEPLOY_HOTFIX.REVISION, it.revisions.joinToString())
                .set(DEPLOY_HOTFIX.HOTFIX_TICKETS, it.hotfixTicketKey.joinToString())
                .set(DEPLOY_HOTFIX.HOTFIX_DATE, it.hotfixTime)
                .set(DEPLOY_HOTFIX.HOTFIX_TYPE, if (it.toProduction) 1L else 0L)
                .newRecord()
        }

        insert.onDuplicateKeyIgnore().execute()
    }

    fun getLastHotfixDate() : LocalDateTime? {
        return dslContextProvider.chassis()
            .select(max(DEPLOY_HOTFIX.HOTFIX_DATE)).from(DEPLOY_HOTFIX).fetchOne()?.value1()
    }
}
