package ru.yandex.direct.chassis.repository

import com.fasterxml.jackson.core.type.TypeReference
import org.springframework.stereotype.Component
import ru.yandex.direct.chassis.entity.regression.restart.PackRestartState
import ru.yandex.direct.chassis.entity.regression.restart.ReleaseRegressionInfo
import ru.yandex.direct.dbschema.chassis.tables.AutotestsState.AUTOTESTS_STATE
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.jooqmapperhelper.InsertHelper
import ru.yandex.direct.utils.JsonUtils

@Component
class RegressionRestartRepository(
    private val dslContextProvider: DslContextProvider,
) {
    fun getRestartState(app: String, releaseKey: String): ReleaseRegressionInfo? {
        return dslContextProvider.chassis()
            .select(
                AUTOTESTS_STATE.APP,
                AUTOTESTS_STATE.RELEASE_KEY,
                AUTOTESTS_STATE.TAG,
                AUTOTESTS_STATE.PACKS
            )
            .from(AUTOTESTS_STATE)
            .where(AUTOTESTS_STATE.APP.eq(app))
            .and(AUTOTESTS_STATE.RELEASE_KEY.eq(releaseKey))
            .fetchOne {
                ReleaseRegressionInfo(
                    app = it[AUTOTESTS_STATE.APP],
                    releaseKey = it[AUTOTESTS_STATE.RELEASE_KEY],
                    tag = it[AUTOTESTS_STATE.TAG],
                    packs = JsonUtils.fromJson(it[AUTOTESTS_STATE.PACKS],
                        object : TypeReference<List<PackRestartState>>() {})
                )
            }
    }

    fun saveRestartState(info: ReleaseRegressionInfo) {
        val insertHelper = InsertHelper(dslContextProvider.chassis(), AUTOTESTS_STATE)
        insertHelper
            .set(AUTOTESTS_STATE.APP, info.app)
            .set(AUTOTESTS_STATE.RELEASE_KEY, info.releaseKey)
            .set(AUTOTESTS_STATE.TAG, info.tag)
            .set(AUTOTESTS_STATE.PACKS, JsonUtils.toJson(info.packs))
            .onDuplicateKeyUpdate()
            .set(AUTOTESTS_STATE.TAG, info.tag)
            .set(AUTOTESTS_STATE.PACKS, JsonUtils.toJson(info.packs))
            .execute()
    }
}
