package ru.yandex.direct.chassis.util.abc

/**
 * Сущность "Смена"
 */
data class Shift(val id: Long, val person: Person)

/**
 * Сущность "Дежурный"
 */
data class Person(val id: Long, val login: String)

data class Service(val id: Long, val slug: String)

data class Scope(val slug: String)
data class Role(val id: Long, val scope: Scope, val code: String)

data class ServiceMember(val id: Long, val person: Person, val service: Service, val role: Role)
data class ServiceMembersResponse(val results: List<ServiceMember>)

enum class ServiceSlug(val slug: String) {
    DIRECT("direct"),
    DIRECT_APP_DUTY("direct-app-duty"),
}

/**
 * Slug расписания
 */
enum class ScheduleSlug(val slug: String) {
    DIRECT_PRODUCTION_DUTY("direct-production-duty"),
    DIRECT_NO_PRODUCTION_DUTY("direct-no-production-duty"),

    DNA_AUTOTEST("dna-autotest-duty"),
}
