package ru.yandex.direct.chassis.util.aqua

import java.time.Instant
import java.util.UUID

/**
 * Список запусков тестов по тегу
 */
data class GetLaunchesResponse(
    val count: Int,
    val skip: Int,
    val limit: Int,
    val launches: List<Launch>,
)

data class RestartResponse(
    val id: String,
)

/**
 * Один запуск пака
*/
data class Launch(
    val id: String,
    val pack: Pack,
    val startTime: Instant,
    val stopTime: Instant,
    val createdTime: Instant,
    val reportRequestTime: Instant,
    val reportStartTime: Instant,
    val reportStopTime: Instant,
    val estimateTime: Instant,
    val user: String,
    val reportDir: String?,
    val reportUrl: String,
    val reportRequestUrl: String,
    val launchUrl: String,
    val totalSuites: Int,
    val failedSuites: Int,
    val revokedSuites: Int,
    val passedSuites: Int,
    val runningSuites: Int,
    val notificationSend: Boolean,
    val reportFiles: List<String>,
    val launchStatus: LaunchStatus,
    val tag: String?,
    val ignoreCascade: Boolean,
    val reportSavedAt: Int,
)

enum class LaunchStatus {
    REPORT_READY,
    FINISHED,
    FAILED,
    REVOKED,
    RUNNABLE,
    RUNNING,
    REPORT_REQUESTED,
    REPORT_STARTED,
    REPORT_FAILED,
}

/**
 * Описание пака
 */
data class Pack(
    val id: String,
    val name: String,
    val nextFire: Instant,
    val monitoring: Boolean,
    val cron: String?,
    val scheduled: Boolean,
    val yard: Boolean,
    val tip: Int,
    val buildReport: Boolean,
    val properties: List<Property>,
    val projects: List<Project>,
)

/**
 * Группа тестов (один jar &mdash; один project)
 */
data class Project(
    val title: String,
    val launchSuites: List<LaunchSuite>,
    val description: String?,
    val id: String,
    val time: Instant,
    val maven: Maven?,
    val properties: List<Property>,
    val labels: List<String>,
)

data class Property(
    val id: String?,
    val title: String?,
    val key: String,
    val value: String,
)

/**
 * Запуск одного теста
 */
data class LaunchSuite(
    val suite: Suite,
    val properties: List<Property>,
    val launchStatus: LaunchStatus,
    val uuid: UUID,
    val logUrl: String?,
    val launchId: String,
    val startTime: Instant,
    val stopTime: Instant,
    val startArrived: Instant,
    val finishArrived: Instant,
    val inBigLaunch: Boolean,
)

/**
 * Описание теста
 */
data class Suite(
    val id: String,
    val name: String,
    val title: String?,
    val type: String?,
    val description: String,
    val project: Project?,
    val feature: String,
    val parameters: List<String>,
    val labels: List<String>,
    val `package`: String,
)

data class Maven(
    val groupId: String,
    val artifactId: String,
    val version: String,
)
