package ru.yandex.direct.chassis.util.buildbot

import org.asynchttpclient.AsyncHttpClient
import org.springframework.stereotype.Component
import ru.yandex.direct.asynchttp.FetcherSettings
import ru.yandex.direct.asynchttp.ParallelFetcherFactory
import ru.yandex.direct.http.smart.annotations.ResponseHandler
import ru.yandex.direct.http.smart.converter.VoidResponseConverter
import ru.yandex.direct.http.smart.core.Call
import ru.yandex.direct.http.smart.core.Smart
import ru.yandex.direct.http.smart.error.ErrorUtils.checkResultForErrors
import ru.yandex.direct.http.smart.http.POST
import ru.yandex.direct.http.smart.http.Path

@Component
class BuildbotClient(
    asyncHttpClient: AsyncHttpClient,
) {
    private val baseUrl = "https://direct.ppcbuild.ppc.yandex.ru"

    private val api: BuildbotApi = Smart.builder()
        .withParallelFetcherFactory(ParallelFetcherFactory(asyncHttpClient, FetcherSettings()))
        .withProfileName("buildbot_client")
        .withBaseUrl(baseUrl)
        .build()
        .create(BuildbotApi::class.java)

    fun restartBuild(builder: String, build: Long) =
        api.restartBuild(builder, build).executeCall()

    private fun <T> Call<T>.executeCall(): T {
        val result = execute()
        checkResultForErrors(result, { RuntimeException(it) })
        return result.success
    }
}

interface BuildbotApi {
    @POST("/builders/{builder}/builds/{build}/rebuild")
    @ResponseHandler(expectedCodes = [302], parserClass = VoidResponseConverter::class)
    fun restartBuild(
        @Path("builder") builder: String,
        @Path("build") build: Long,
    ): Call<Void>
}
