package ru.yandex.direct.chassis.util.calendar

import org.asynchttpclient.AsyncHttpClient
import org.springframework.stereotype.Component
import ru.yandex.direct.asynchttp.FetcherSettings
import ru.yandex.direct.asynchttp.ParallelFetcherFactory
import ru.yandex.direct.http.smart.annotations.Json
import ru.yandex.direct.http.smart.core.Call
import ru.yandex.direct.http.smart.core.Smart
import ru.yandex.direct.http.smart.error.ErrorUtils.checkResultForErrors
import ru.yandex.direct.http.smart.http.GET
import ru.yandex.direct.http.smart.http.Query
import java.time.LocalDate

@Component
class CalendarClient(
    asyncHttpClient: AsyncHttpClient,
) {
    companion object {
        private const val API_URL = "https://api.calendar.yandex-team.ru/intapi"
    }

    private val api: CalendarApi = Smart.builder()
        .withParallelFetcherFactory(ParallelFetcherFactory(asyncHttpClient, FetcherSettings()))
        .withProfileName("calendar_client")
        .withBaseUrl(API_URL)
        .build()
        .create(CalendarApi::class.java)

    fun getHolidays(from: LocalDate, to: LocalDate) =
        api.getHolidays(from, to).executeCall().holidays

    private fun <T> Call<T>.executeCall(): T {
        val result = execute()
        checkResultForErrors(result, { RuntimeException(it) })
        return result.success
    }
}

interface CalendarApi {
    @GET("/get-holidays")
    @Json
    fun getHolidays(
        @Query("from") from: LocalDate,
        @Query("to") to: LocalDate,
        @Query("for") country: String = "rus",
        @Query("outMode") mode: String = "all",
    ): Call<HolidaysResponse>
}
